// Quarterly policy rules with quarterly uncertainty and Skewness variables

clear

// pick the folder for data:

//cd "D:\Projects\Brookings 2015\Taylor Rules\Data"
cd "C:\Users\g1tjs01\Documents\brookings\1987 extension\files for final submission"


// basic data
// point forecasts in 1987 datasets are calculated directly (not weighting annual forecasts)
use quarterlyData, clear

// pick the directory for output
cd "C:\Users\g1tjs01\Documents\brookings\1987 extension\files for final submission\output"
//cd "D:\Projects\Brookings 2015\Taylor Rules\Stata"

// make time series 
tsset time
drop if time>tq(2008q4)

// Convenient change of name
rename old_vix vix  // Use old version of VIX (highly correlated with new version) to extend sample back to 1987q3
quietly summarize vix
replace vix = (vix-r(mean))/r(sd)

// credit spread
quietly summarize credit_spread if time>=tq(1987q3)
replace credit_spread = (credit_spread-r(mean))/r(sd)

// define variables for taylor rule estimation
gen corecpi_4q = (corecpi_T0 + corecpi_T1 + corecpi_T2 + corecpi_T3 )/4
gen outputgap_4q = (outputgap_T0 + outputgap_T1 + outputgap_T2 + outputgap_T3)/4
gen ffr = ffr_thirty_days_forward 

// Define uncertainty and disagreement variables
// Uncertainty variables are based on constant horizon forecasts dervied from weighting quarterly binned forecasts of current and following year
// Disagreement variables based on direct constant horizon point forecasts

// Uncertainty
gen UncInf = med_of_chinf_bin_stdev
gen UncGDP = med_of_chgdp_bin_stdev
quietly summarize UncInf if time>=tq(1992q1)
replace UncInf = (UncInf-r(mean))/r(sd)
quietly summarize UncGDP if time>=tq(1992q4)
replace UncGDP = (UncGDP-r(mean))/r(sd)


// Disagreement
gen DisagInfl = iqr_pf_inflation_ch
gen DisagGDP = iqr_pf_gdp_ch
quietly summarize DisagInfl if time>=tq(1987q3)
replace DisagInfl = (DisagInfl-r(mean))/r(sd)
quietly summarize DisagGDP if time>=tq(1987q3)
replace DisagGDP = (DisagGDP-r(mean))/r(sd)


// central tendency across forecasters of mean less mode (From the bins, using weighted bins) 
gen meanlessmodeInfl = median_mlmo_chinf_bin
gen meanlessmodeGDP  = median_mlmo_chgdp_bin
quietly summarize meanlessmodeInfl if time>=tq(1992q1)
replace meanlessmodeInfl = (meanlessmodeInfl-r(mean))/r(sd)
quietly summarize meanlessmodeGDP if time>=tq(1992q1)
replace meanlessmodeGDP = (meanlessmodeGDP-r(mean))/r(sd)


// Mean minus mode (across forecasters) of constant horizon point forecasts 
gen meanlessmodeInflPF = - mode_pf_inflation_ch + mean_pf_inflation_ch
gen meanlessmodeGDPPF = - mode_pf_gdp_ch + mean_pf_gdp_ch
quietly summarize meanlessmodeInflPF if time>=tq(1987q3)
replace meanlessmodeInflPF = (meanlessmodeInflPF-r(mean))/r(sd)
quietly summarize meanlessmodeGDPPF if time>=tq(1987q3)
replace meanlessmodeGDPPF = (meanlessmodeGDPPF-r(mean))/r(sd)

// Jurado-Ludvigson-Ng uncertainty variable
gen lunc = h12_macro_uncert
gen luncact = h12_act_uncert
gen luncinf = h12_inf_uncert
scalar lam1=70/132
scalar lam2=24/132
gen luncoth = (lunc-lam1*luncact-lam2*luncinf)/(1-lam1-lam2)

quietly summarize lunc if time>=tq(1987q3)
replace lunc = (lunc-r(mean))/r(sd)

quietly summarize luncact if time>=tq(1987q3)
replace luncact = (luncact-r(mean))/r(sd)

quietly summarize luncinf if time>=tq(1987q3)
replace luncinf = (luncinf-r(mean))/r(sd)

quietly summarize luncoth if time>=tq(1987q3)
replace luncoth = (luncoth-r(mean))/r(sd)

// Label variables
label var time "quarter"
label var corecpi_4q "Four-quarter average of core CPI"
label var outputgap_4q "Four-quarter average of output gap"
label var ffr "Thirty day forward average of Fed Funds Rate target after FOMC meetings"
label var UncInf "Median across forecasters of the standard deviation of probability-based inflation forecasts"
label var UncGDP "Median across forecasters of the standard deviation of probability-based GDP forecasts"
label var DisagInfl "Interquartile range of inflation point forecasts"
label var DisagGDP "Interquartile range of GDP point forecasts"
label var meanlessmodeInfl "Median across forecasters of mean-less-mode probability-based inflation forecasts"
label var meanlessmodeGDP "Median across forecasters of the standard deviation of probability-based GDP forecasts"
label var meanlessmodeInflPF "Mean minus mode inflation point forecasts"
label var meanlessmodeGDPPF "Mean minus mode GDP point forecasts"
label var lunc "Junrado-Ludvigson-Ng macroeconomic uncertainty"
label var luncact "JLN activity uncertainty"
label var luncinf "JLN inflation uncertainty"
label var luncoth "JLN residual uncertainty"


// Uncertainty Table

reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q if time>=tq(1987q3), robust
estat durbinalt, lags(2) force robust 
matrix input table_UNC_r = (1,1,1,1,1,1,1)
matrix table_UNC_r[1,1] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_UNC, vars(rho1 rho2 beta gamma VXO JLN vInf vGDP DvInf DvGDP) replace name(col1) e(r2_a)
quietly: reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q if time>=tq(1987q3), robust
matrix table_UNC_e[2,1] = e(r2_a)

// financial variable - variance
reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  vix if time>=tq(1987q3), robust
estat durbinalt, lags(2) force robust 
matrix table_UNC_r[1,2] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (VXO: _b[vix]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_UNC, addto(table_UNC) name(col2)
quietly: reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  vix if time>=tq(1987q3) , robust
matrix table_UNC_e[2,2] = e(r2_a)

// macro uncertainty variable
reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  lunc if time>=tq(1987q3) , robust
estat durbinalt, lags(2) force robust 
matrix table_UNC_r[1,3] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (JLN: _b[lunc]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_UNC, addto(table_UNC) name(col3)
quietly: reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  lunc if time>=tq(1987q3), robust
matrix table_UNC_e[2,3] = e(r2_a)


// SPF bin-based variables
reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  UncInf if time>=tq(1992q1), robust
estat durbinalt, lags(2) force robust 
matrix table_UNC_r[1,4] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (vInf: _b[UncInf]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_UNC, addto(table_UNC) name(col4)
quietly: reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  UncInf if time>=tq(1992q1), robust
matrix table_UNC_e[2,4] = e(r2_a)

reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  UncGDP if time>=tq(1992q1), robust
estat durbinalt, lags(2) force robust 
matrix table_UNC_r[1,5] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (vGDP: _b[UncGDP]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_UNC, addto(table_UNC) name(col5)
quietly: reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  UncGDP if time>=tq(1992q1), robust
matrix table_UNC_e[2,5] = e(r2_a)

// SPF point forecast based variables

reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  DisagInfl if time>=tq(1987q3), robust
estat durbinalt, lags(2) force robust 
matrix table_UNC_r[1,6] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (DvInf: _b[DisagInfl]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_UNC, addto(table_UNC) name(col6)
reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  DisagInfl if time>=tq(1987q3), robust
matrix table_UNC_e[2,6] = e(r2_a)

reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  DisagGDP if time>=tq(1987q3), robust
estat durbinalt, lags(2) force robust 
matrix table_UNC_r[1,7] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (DvGDP: _b[DisagGDP]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_UNC, addto(table_UNC) name(col7)
quietly: reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  DisagGDP if time>=tq(1987q3), robust
matrix table_UNC_e[2,7] = e(r2_a)

// Input to Table 9
est2tex table_UNC, preserve replace mark(starb) level(90 95 99) digits(2) fancy path("C:\swp55\Docs\Brookings 2015\Tables") collabels()


// Asymmetry Table mean>median, mean>mode => positive skew


reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q if time>=tq(1987q3), robust
estat durbinalt, lags(2) force robust 
matrix input table_Asym_r = (1,1,1,1,1,1)
matrix table_Asym_r[1,1] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_Asym, vars(rho1 rho2 beta gamma Spread sInf sGDP DsInf DsGDP) e(r2_a) replace name(col1)
quietly: reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q if time>=tq(1987q3), robust
matrix table_Asym_e[2,1] = e(r2_a)

// financial variable - skewness
reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  credit_spread if time>=tq(1987q3), robust
estat durbinalt, lags(2) force robust 
matrix table_Asym_r[1,2] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (Spread: _b[credit_spread]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_Asym, addto(table_Asym) name(col2)
quietly: reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  credit_spread if time>=tq(1987q3), robust
matrix table_Asym_e[2,2] = e(r2_a)

// SPF bin-based variables

reg ffr L.ffr L2.ffr  corecpi_4q outputgap_4q meanlessmodeInfl if time>=tq(1992q1), robust
estat durbinalt, lags(2) force robust 
matrix table_Asym_r[1,3] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (sInf: _b[meanlessmodeInfl]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_Asym, addto(table_Asym) name(col3)
quietly: reg ffr L.ffr L2.ffr  corecpi_4q outputgap_4q meanlessmodeInfl if time>=tq(1992q1), robust
matrix table_Asym_e[2,3] = e(r2_a)

reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  meanlessmodeGDP if time>=tq(1992q1), robust
estat durbinalt, lags(2) force robust 
matrix table_Asym_r[1,4] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (sGDP: _b[meanlessmodeGDP]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_Asym, addto(table_Asym) name(col4)
quietly: reg ffr L.ffr L2.ffr corecpi_4q outputgap_4q  meanlessmodeGDP if time>=tq(1992q1), robust
matrix table_Asym_e[2,4] = e(r2_a)

// SPF point forecast based variables


reg ffr L.ffr L2.ffr  corecpi_4q outputgap_4q  meanlessmodeInflPF if time>=tq(1987q3), robust
estat durbinalt, lags(2) force robust 
matrix table_Asym_r[1,5] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (DsInf: _b[meanlessmodeInflPF]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_Asym, addto(table_Asym) name(col5)
quietly: reg ffr L.ffr L2.ffr  corecpi_4q outputgap_4q  meanlessmodeInflPF if time>=tq(1987q3), robust
matrix table_Asym_e[2,5] = e(r2_a)

reg ffr L.ffr L2.ffr  corecpi_4q outputgap_4q  meanlessmodeGDPPF if time>=tq(1987q3), robust
estat durbinalt, lags(2) force robust 
matrix table_Asym_r[1,6] = r(p)
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (DsGDP: _b[meanlessmodeGDPPF]/(1-_b[L.ffr]-_b[L2.ffr])) , post
est2vec table_Asym, addto(table_Asym) name(col6)
quietly: reg ffr L.ffr L2.ffr  corecpi_4q outputgap_4q  meanlessmodeGDPPF if time>=tq(1987q3), robust
matrix table_Asym_e[2,6] = e(r2_a)

// Input to Table 10
est2tex table_Asym, preserve replace mark(starb) level(90 95 99) digits(2) fancy path("C:\swp55\Docs\Brookings 2015\Tables") collabels()


// evaluate source of JLN effect

reg ffr L.ffr L2.ffr  corecpi_4q outputgap_4q  lunc, robust
estat durbinalt, lags(2) force robust 
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (dUnc: _b[lunc]/(1-_b[L.ffr]-_b[L2.ffr])) , post

reg ffr L.ffr L2.ffr  corecpi_4q outputgap_4q  luncinf, robust
estat durbinalt, lags(2) force robust 
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (dUnc: _b[luncinf]/(1-_b[L.ffr]-_b[L2.ffr])) , post

reg ffr L.ffr L2.ffr  corecpi_4q outputgap_4q  luncact, robust
estat durbinalt, lags(2) force robust 
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (dUnc: _b[luncact]/(1-_b[L.ffr]-_b[L2.ffr])) , post

reg ffr L.ffr L2.ffr  corecpi_4q outputgap_4q  luncoth, robust
estat durbinalt, lags(2) force robust 
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (dUnc: _b[luncoth]/(1-_b[L.ffr]-_b[L2.ffr])) , post

 
reg ffr L.ffr L2.ffr  corecpi_4q outputgap_4q  luncinf luncact luncoth, robust
estat durbinalt, lags(2) force robust 
nlcom (rho1: _b[L.ffr]) (rho2: _b[L2.ffr]) (beta: _b[corecpi_4q]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (gamma: _b[outputgap_4q]/(1-_b[L.ffr]-_b[L2.ffr])) (dUncinf: _b[luncinf]/(1-_b[L.ffr]-_b[L2.ffr])) ///
  (dUncact: _b[luncact]/(1-_b[L.ffr]-_b[L2.ffr])) (dUncoth: _b[luncoth]/(1-_b[L.ffr]-_b[L2.ffr])) , post

